<?php
function delete_esxi_vswitch($argv) {
	/* check number of arguments */
	if(count($argv) != 4) {
		echo "Usage: delete_esxi_vswitch ESXI_HOST ESXI_USERNAME ESXI_PASSWORD VSWITCH_NAME\n";
		exit(1);
	}

	/* fetch arguments */
	$esxi_host = escapeshellarg($argv[0]);
	$esxi_username = escapeshellarg($argv[1]);
	$esxi_password = escapeshellarg($argv[2]);
	$vswitch_name = escapeshellarg($argv[3]);

	/* execute main function */
	unset($result_array);
	exec("vicfg-vswitch --server $esxi_host --username $esxi_username --password $esxi_password --check $vswitch_name 2>&1", $result_array, $return_value);
	if($return_value != 0) {
		echo "vicfg-vswitch error\n";
		exit(1);
	}
	
	/* the vswitch is not exist */
	if($result_array[0] == 0) {
		exit(0);
	}

	unset($result_array);
	exec("vicfg-vswitch --server $esxi_host --username $esxi_username --password $esxi_password --delete $vswitch_name 2>&1", $result_array, $return_value);
	/* didn't check return code, anyway, return them */
	foreach($result_array as $line) {
		echo $line . "\n";
	}
	
	exit($return_value);
}

